<?php

namespace Fisharebest\Localization\Locale;

use Fisharebest\Localization\Language\LanguageHsb;

/**
 * Class LocaleHsb - Upper Sorbian
 *
 * @author    Greg Roach <greg@subaqua.co.uk>
 * @copyright (c) 2022 Greg Roach
 * @license   GPL-3.0-or-later
 */
class LocaleHsb extends AbstractLocale implements LocaleInterface
{
    public function endonym()
    {
        return 'hornjoserbšćina';
    }

    public function endonymSortable()
    {
        return 'HORNJOSERBSCINA';
    }

    public function language()
    {
        return new LanguageHsb();
    }

    public function numberSymbols()
    {
        return array(
            self::GROUP   => self::DOT,
            self::DECIMAL => self::COMMA,
        );
    }

    protected function percentFormat()
    {
        return self::PLACEHOLDER . self::NBSP . self::PERCENT;
    }
}
